clear all

* Set folder

cd ..\Outputs

use SEMESTER, clear

* Variables we want to put in table:
* Shocks:           PROD3 OILS2 MONSH5 FE1
* L.H.S. variables: G(Y or P)(IMF, OEC or COC)tp0gtm0

foreach v of varlist PROD3 OILS2 MONSH5 FE1 G?IMFtp0gtm0 G?OECtp0gtm0 ///
                     GYCOCtp0gtm0 {
	bys ISO: egen firs_temp_`v'=min(year) if `v'!=.
	by  ISO: egen last_temp_`v'=max(year) if `v'!=.
	by  ISO: egen firs_year_`v'=mean(firs_temp_`v')
	by  ISO: egen last_year_`v'=mean(last_temp_`v')
	drop ????_temp*
	tostring ????_year_*, replace
	gen period`v'=firs_year_`v'+"-"+last_year_`v'
	drop ????_year_*
	replace period`v'="No data" if period`v'==".-."
}

bys ISO: keep if _n==1
keep Country period*
rename period* *
